//
//  IFBarButton.m
//  Downloader
//
//  Created by hxhg-LiDong on 13-2-9.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import "IFBarButton.h"

@implementation IFBarButton

- (void)willMoveToSuperview:(UIView *)newSuperview {
    const CGRect superFrame = [newSuperview frame];
    const CGRect thisFrame = { 0, 0, 44, superFrame.size.height };
    
    [self setFrame:thisFrame];
}

- (CGRect)imageRectForContentRect:(CGRect)contentRect {
    const CGFloat edgeLength = (NSInteger)(contentRect.size.height / 2.f + 2.5f);
    const CGFloat offsetX = (NSInteger)((contentRect.size.width - edgeLength) / 2.f);
    const CGFloat offsetY = (NSInteger)((contentRect.size.height - edgeLength) / 2.f);
    const CGRect imageRect = { offsetX, offsetY, edgeLength, edgeLength };
    return imageRect;
}

@end
